#!/usr/bin/perl
#
$Version = 0.01;
@ARGV = (	"../phrases/phrases_en.xml", 
			"../phrases/phrases_fr.xml", 
			"../phrases/phrases_de.xml",
			"../phrases/phrases_nl.xml",
			"../phrases/phrases_es.xml",
			"../phrases/phrases_ar.xml",
			);

#
# Extracts the phrases from each $argv and compares thems
#
# Usage : phraseval.pl
#

%set_phrases = ();
@languages = ();
$n = 0;

while ($xml = shift @ARGV) {
    open XML , "<$xml" or die "Unable to open $xml";
    $languages[++$n] = $xml;
    $phraselist = "";
    while (<XML>) { $phraselist .= $_; }
    close XML;
    while ($phraselist =~ m/<phrase name="(.*?)" [^>]*><!.CDATA.(.*?)..><\/phrase>/gs) {
		if (!exists($set_phrases{$1})) {
			$set_phrases{$1} = [];
		}
        push(@{$set_phrases{$1}}, $2);
    }
}

foreach $phrase (sort keys %set_phrases) {
	print $phrase."\n";
    foreach $trans (@{$set_phrases{$phrase}}) {
	    @subs = split /\{[^}]+?\}/, " ".$trans." ";
	    printf("%3d %s\n", $#subs, $trans);
    }
    print "\n";
}

